import { getInvite } from "@/lib/store";
import { inviteUrl } from "@/lib/links";

export async function GET(req, { params }) {
  const data = await getInvite(params.token);
  if (!data) return new Response(JSON.stringify({ error: "not_found" }), { status: 404, headers: { "content-type": "application/json" } });

  const { event, guest, rsvp } = data;
  return new Response(JSON.stringify({
    token: params.token,
    link: inviteUrl(params.token),
    event,
    guest,
    rsvp,
  }), { headers: { "content-type": "application/json" } });
}
